﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    public partial class event_subscriber
    {
        public event_subscriber()
        {
        }

        public event_subscriber(System.String event_up_name, System.Int32 method_id, System.Guid subscriber_id, System.String tagName)
        {
            this.event_up_name = event_up_name;
            this.method_id = method_id;
            this.method_address = string.Empty;
            this.subscriber_id = subscriber_id;
            this.tag_name = tagName;
        }

        public event_subscriber(System.String event_up_name, System.Int32 method_id, System.String method_address, System.Guid subscriber_id, System.String tagName)
        {
            this.event_up_name = event_up_name;
            this.method_id = method_id;
            this.method_address = method_address;
            this.subscriber_id = subscriber_id;
            this.tag_name = tagName;
        }


        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            //if there will be subscribers edit we should add unique field to this table
            get { return string.Format("{0}{1}{2}{3}", event_up_name, method_id, subscriber_id, tag_name == null ? string.Empty : tag_name); }
        }

        private static readonly List<string> _event_subscriberProperties =
            new List<string> 
                { 
                    "event_up_name", "method_id", "method_address", "subscriber_id", "tag_name"
                };

        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _event_subscriberProperties; }
        }

        #endregion
    }
}

